/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.impl;

import com.quantumdata.sct.dao.exception.CreateException;
import com.quantumdata.sct.dao.exception.DAOException;
import com.quantumdata.sct.dao.exception.ReadException;
import com.quantumdata.sct.dao.impl.AbstractXMLStorageDAO;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.jaxb.DeviceCapabilities;
import com.quantumdata.sct.dao.jaxb.DeviceCapabilitiesType;
import com.quantumdata.sct.dao.jaxb.DeviceCapability;
import com.quantumdata.sct.dao.vo.DeviceCapabilityVO;
import com.quantumdata.sct.util.keygen.KeyGenerator;
import com.quantumdata.sct.util.keygen.RandTSKeyGenerator;
import java.util.ArrayList;
import java.util.Iterator;

public final class DeviceCapabilityDAO
extends AbstractXMLStorageDAO {
    private KeyGenerator keygen = RandTSKeyGenerator.instance();

    private DeviceCapabilitiesType.DeviceCapability get(Integer n) throws ReadException {
        if (n == null) {
            throw new ReadException("Invalid index");
        }
        int n2 = ((DeviceCapabilities)this.daoObject).getDeviceCapabilitiesCollection().size();
        if (n >= n2) {
            throw new ReadException("Index out of bounds error");
        }
        DeviceCapabilitiesType.DeviceCapability deviceCapability = (DeviceCapabilitiesType.DeviceCapability)((DeviceCapabilities)this.daoObject).getDeviceCapabilitiesCollection().get(n);
        return deviceCapability;
    }

    public void readCallback() throws DAOException {
        try {
            DeviceCapabilities deviceCapabilities = (DeviceCapabilities)this.daoObject;
            int n = deviceCapabilities.getDeviceCapabilitiesCollection().size();
            this.daoCollection.clear();
            for (int i = 0; i < n; ++i) {
                DeviceCapabilitiesType.DeviceCapability deviceCapability = (DeviceCapabilitiesType.DeviceCapability)deviceCapabilities.getDeviceCapabilitiesCollection().get(i);
                this.daoCollection.put(deviceCapability.getDeviceId(), new Integer(i));
                ++i;
            }
            this.initialize = true;
        }
        catch (Exception exception) {
            this.initialize = false;
            throw new DAOException("Unable to load", null, exception);
        }
    }

    public final Object getUniqueKey() {
        return this.keygen.generateUniqueKey();
    }

    public final IPersistable getValueObjectForKey(Object object) throws CreateException {
        IPersistable iPersistable = null;
        try {
            if (!this.daoCollection.containsKey(object)) {
                throw new Exception("Element with key = " + object + " not found");
            }
            Integer n = (Integer)this.daoCollection.get(object);
            DeviceCapabilitiesType.DeviceCapability deviceCapability = this.get(n);
            iPersistable = this.createPersistable(deviceCapability);
        }
        catch (Exception exception) {
            throw new CreateException(exception.getMessage());
        }
        return iPersistable;
    }

    public final IPersistable[] findByAll() throws Exception {
        int n = ((DeviceCapabilities)this.daoObject).getDeviceCapabilitiesCollection().size();
        IPersistable[] iPersistableArray = new IPersistable[n];
        for (int i = 0; i < n; ++i) {
            DeviceCapabilitiesType.DeviceCapability deviceCapability = (DeviceCapabilitiesType.DeviceCapability)((DeviceCapabilities)this.daoObject).getDeviceCapabilitiesCollection().get(i);
            iPersistableArray[i] = this.createPersistable(deviceCapability);
        }
        return iPersistableArray;
    }

    public final Object getUniqueKey(Object object) {
        Object object2 = null;
        if (object instanceof DeviceCapabilitiesType.DeviceCapability) {
            DeviceCapabilitiesType.DeviceCapability deviceCapability = (DeviceCapabilitiesType.DeviceCapability)object;
            object2 = deviceCapability.getDeviceId();
        } else {
            object2 = this.getUniqueKey();
        }
        return object2;
    }

    private IPersistable createPersistable(Object object) throws Exception {
        DeviceCapabilityVO deviceCapabilityVO = new DeviceCapabilityVO();
        if (object instanceof DeviceCapabilitiesType.DeviceCapability) {
            this.copyFrom((DeviceCapabilitiesType.DeviceCapability)object, deviceCapabilityVO);
        }
        return deviceCapabilityVO;
    }

    private void copyFrom(DeviceCapabilitiesType.DeviceCapability deviceCapability, DeviceCapabilityVO deviceCapabilityVO) throws Exception {
        deviceCapabilityVO.setId(deviceCapability.getDeviceId());
        deviceCapabilityVO.setLastUpdate(deviceCapability.getLastUpdateTime());
        ArrayList<DeviceCapabilityVO.DeviceCapabilityElementVO> arrayList = new ArrayList<DeviceCapabilityVO.DeviceCapabilityElementVO>();
        int n = deviceCapability.getCapabilities().size();
        for (int i = 0; i < n; ++i) {
            DeviceCapability.DeviceCapabilityElement deviceCapabilityElement = (DeviceCapability.DeviceCapabilityElement)deviceCapability.getCapabilities().get(i);
            DeviceCapabilityVO.DeviceCapabilityElementVO deviceCapabilityElementVO = new DeviceCapabilityVO.DeviceCapabilityElementVO();
            deviceCapabilityElementVO.setCapabilityId(deviceCapabilityElement.getCapabilityId());
            deviceCapabilityElementVO.setMandatory(deviceCapabilityElement.isMandatory());
            arrayList.add(deviceCapabilityElementVO);
        }
        deviceCapabilityVO.setDeviceCapabilityElements(arrayList);
    }

    private void copyTo(DeviceCapabilitiesType.DeviceCapability deviceCapability, DeviceCapabilityVO deviceCapabilityVO) throws Exception {
        deviceCapability.setDeviceId((String)deviceCapabilityVO.getId());
        deviceCapability.setLastUpdateTime(deviceCapabilityVO.getLastUpdate());
        Iterator iterator = deviceCapabilityVO.getDeviceCapabilityElements().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            DeviceCapability.DeviceCapabilityElement deviceCapabilityElement = this.factory.createDeviceCapabilityDeviceCapabilityElement();
            DeviceCapabilityVO.DeviceCapabilityElementVO deviceCapabilityElementVO = (DeviceCapabilityVO.DeviceCapabilityElementVO)iterator.next();
            deviceCapabilityElement.setMandatory(deviceCapabilityElementVO.isMandatory());
            deviceCapabilityElement.setCapabilityId(deviceCapabilityElementVO.getCapabilityId());
            deviceCapability.getCapabilities().set(n, deviceCapabilityElement);
            ++n;
        }
    }

    protected final void updateObject(IPersistable iPersistable) throws Exception {
        if (iPersistable instanceof DeviceCapabilityVO) {
            DeviceCapabilityVO deviceCapabilityVO = (DeviceCapabilityVO)iPersistable;
            Integer n = (Integer)this.daoCollection.get(deviceCapabilityVO.getId());
            DeviceCapabilitiesType.DeviceCapability deviceCapability = this.get(n);
            this.copyTo(deviceCapability, deviceCapabilityVO);
        }
    }

    protected final IPersistable findByPrimaryKey(String string) {
        DeviceCapabilityVO deviceCapabilityVO = null;
        try {
            if (this.daoCollection.containsKey(string)) {
                Integer n = (Integer)this.daoCollection.get(string);
                DeviceCapabilitiesType.DeviceCapability deviceCapability = this.get(n);
                deviceCapabilityVO = new DeviceCapabilityVO();
                this.copyFrom(deviceCapability, deviceCapabilityVO);
            }
        }
        catch (Exception exception) {
            this.log(exception.getMessage());
            deviceCapabilityVO = null;
        }
        return deviceCapabilityVO;
    }

    protected final void removeByPrimaryKey(Object object) throws DAOException {
        try {
            if (object instanceof String) {
                Integer n = (Integer)this.daoCollection.get(object);
                ((DeviceCapabilities)this.daoObject).getDeviceCapabilitiesCollection().remove(n);
            }
            this.flush();
            this.readCallback();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new DAOException(throwable.getMessage());
        }
    }

    public final void add(IPersistable iPersistable) throws CreateException {
        this.add(iPersistable, 0);
    }

    public final void add(IPersistable iPersistable, int n) throws CreateException {
        try {
            if (iPersistable instanceof DeviceCapabilityVO) {
                DeviceCapabilitiesType.DeviceCapability deviceCapability = this.factory.createDeviceCapabilitiesTypeDeviceCapability();
                this.copyTo(deviceCapability, (DeviceCapabilityVO)iPersistable);
                if (n > 0) {
                    ((DeviceCapabilities)this.daoObject).getDeviceCapabilitiesCollection().add(n, iPersistable);
                } else {
                    ((DeviceCapabilities)this.daoObject).getDeviceCapabilitiesCollection().add(iPersistable);
                }
            } else {
                throw new Exception("Invalid Value Object being passed");
            }
            this.flush();
            this.readCallback();
        }
        catch (Exception exception) {
            throw new CreateException("Unable to add element = " + iPersistable.getId(), null, exception);
        }
    }
}

